@echo off

rem Check if running as administrator
net session >nul 2>&1
if %errorlevel% NEQ 0 (
    echo Administrator rights required. Please run the script as an administrator.
    pause
    exit /b 1
)

echo Configuring Assignment for The mSupply Foundation... Please wait! 

rem Importing registry file...
regedit /s "TeamViewer_Settings.reg"
if %errorlevel% neq 0 (
    echo Failed to import TeamViewer registry settings. Please check the registry file exists in %~dp0.
    pause
    exit /b 1
)

"%ProgramFiles%\TeamViewer\TeamViewer.exe" assign --api-token 24696914-2jggyl5FDlOO5hg240MA --alias %COMPUTERNAME% --grant-easy-access
if %errorlevel% neq 0 (
    echo Failed to assign TeamViewer to The mSupply Foundation. Please check the API token and network connection.
    pause
    exit /b 1
)
echo Settings applied. Restarting TeamViewer service...

rem Stop the TeamViewer service
net stop "TeamViewer" >nul 2>&1
if %errorlevel% neq 0 (
    echo Failed to stop TeamViewer service. It may not be running or you need administrator rights.
    pause
    exit /b 1
)

rem Start the TeamViewer service
net start "TeamViewer" >nul 2>&1

if %errorlevel% neq 0 (
    echo Failed to start TeamViewer service. Please check the installation and permissions.
    pause
    exit /b 1
)

echo.
echo TeamViewer assignment complete. Please contact support@msupply.org.nz if you have any issues.